
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Dec 26 17:51:40 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief HMAC ATP test vectors
   *
   *  \version CRYS_Ext_ATP_HMAC_Acceptance_test_vectors.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
   
/* disabling pc lint warning regarding to few initializers in braces :
   Too few initializers for aggregate 'unknown-name' */
/*lint --e{785} */   
   
/***************************
 * File Name:                                                           
 *  CRYS_ATP_TST_HMAC_Acceptance_test_vectors.c         
 *
 * Description:                                                                 
 *  This file contatind the test vectors used for HMAC Acceptance tests                             
 *
 **************************/

/***** Include Files ******/
#include "CRYS_Ext_ATP_HMAC_Acceptance.h"

/******** Defines ************/
/******** Enums ************/
/******** Typedefs ***********/
/******** Global Data **********/
/***** Private function prototype **********/
/******** Public Functions *********/
/******** Private Functions ********/

TST_Ext_HMAC_TestDataStruct SEP_HMAC_Acceptance_TestData[] =
{
    { 
        {"Acceptance test - HMAC/32byteKey/1536ByteData "},
        /*TST_key*/
        {0x88,0x50,0xb0,0x58,0x33,0x99,0x35,0xe8,0x6f,0x6a,0x7a,0x36,0x69,0x06,0x3f,0x55,
        0x01,0xa4,0x77,0xbd,0xd9,0x2a,0xfa,0x36,0xac,0x38,0x7a,0xf8,0xe2,0x68,0xb8,0x10},
        /*TST_keySize */
        32*sizeof(DxUint8_t),
        /*TST_input_data*/
        {0xb0,0x37,0x14,0x55,0x76,0x15,0x22,0x6d,0xa7,0x58,0x15,0xa5,0x0f,0x2c,0xb4,0xb4,
        0x5d,0x15,0xc6,0x58,0x26,0xe0,0x32,0xea,0x2c,0xda,0x65,0x35,0xdf,0x3f,0xf4,0x88,
        0x24,0xf5,0x82,0x0a,0x56,0x7a,0xe5,0x4e,0x8a,0x1c,0x84,0x27,0x18,0x68,0x03,0xbe,
        0x57,0xe4,0x23,0xe1,0xa7,0x01,0xe3,0x9e,0xb5,0x4b,0xec,0x11,0xfa,0xe3,0x2b,0x7a,
        0x85,0x2f,0xc0,0x92,0xfb,0xd0,0x17,0x20,0xdc,0xd4,0x54,0xc7,0x07,0x2d,0xf5,0x22,
        0x81,0x62,0xb2,0x13,0x72,0x85,0xa8,0x57,0x70,0x65,0xb7,0x5e,0x00,0x04,0x29,0x5a,
        0x5a,0x4c,0x94,0x97,0x6d,0xfd,0x01,0x0a,0x23,0xea,0x4d,0x2c,0xe6,0x65,0xd0,0x09,
        0x63,0xf8,0x3d,0x93,0x8e,0x56,0xc9,0x3d,0xe6,0x90,0x90,0xc5,0xfa,0x8c,0x34,0x51,
        0x2c,0xb4,0xc7,0xbe,0xb5,0xeb,0xeb,0x35,0xe9,0xc5,0x37,0xff,0xbc,0xf7,0xdd,0x9a,
        0x86,0x0c,0x8a,0x0c,0x03,0x5a,0x8e,0x77,0x9e,0x35,0x3d,0xee,0xef,0x62,0x95,0x87,
        0x82,0xce,0x21,0xb1,0xda,0x80,0x1c,0xc8,0xb5,0xcd,0xda,0xe7,0x92,0xcb,0x64,0xfe,
        0x71,0x08,0x63,0x24,0xda,0x7b,0x3f,0x2e,0x20,0xba,0x87,0x80,0xe7,0x6e,0x94,0x23,
        0xe4,0x04,0x69,0x18,0xe4,0xa6,0xde,0xec,0x10,0x6a,0xfe,0x8d,0x6f,0xc9,0xad,0x5c,
        0xac,0x52,0x8e,0x83,0x1a,0x9f,0x23,0x89,0xf5,0x89,0x36,0x24,0xeb,0x98,0x78,0x4e,
        0xda,0xbd,0x69,0x9a,0xdc,0x44,0x77,0xc9,0x81,0x04,0x6a,0x98,0x5b,0xd9,0xff,0xdd,
        0xc0,0x54,0xd3,0xd2,0xcb,0xb0,0x83,0xb1,0xa4,0x08,0x12,0x81,0x01,0xc8,0x8b,0x2f,
        0xed,0x62,0xe7,0xe0,0xc9,0x42,0x30,0x86,0x90,0x03,0xe7,0xb1,0x5f,0xe3,0xa4,0xa9,
        0x34,0x74,0xfc,0xb9,0xf5,0x95,0xa7,0xcd,0xb5,0xa1,0xe2,0x40,0x34,0xe6,0x13,0xef,
        0xa4,0x59,0xac,0x92,0xb3,0x87,0x51,0x4c,0xc5,0xcf,0x3d,0x80,0x81,0xcf,0xe2,0xe7,
        0x90,0x1c,0xcf,0xdf,0xa1,0x36,0xd7,0x06,0xb1,0xbb,0x70,0x08,0x89,0xda,0x59,0xb5,
        0x88,0x0b,0x80,0x57,0xa2,0xfd,0x22,0x42,0xa9,0xd0,0x34,0xac,0xcb,0x85,0x02,0xbf,
        0x5d,0xb3,0x16,0xed,0xd7,0x7b,0x5b,0x84,0x1f,0xbd,0x82,0x82,0x0a,0x8c,0xa5,0xaa,
        0x20,0xe0,0x2a,0xd7,0x9f,0x8b,0xeb,0x91,0xc3,0x6f,0x93,0xde,0x45,0xed,0x4b,0x5a,
        0x21,0xa1,0x97,0x8a,0x9d,0x4c,0x7a,0x6e,0x87,0x11,0xe1,0x55,0xbe,0xe5,0x3f,0xf5,
        0xf4,0x41,0x74,0xbb,0xb1,0x19,0xf3,0x60,0x9b,0x12,0x24,0xbd,0xf6,0xf0,0x07,0xe0,
        0x67,0x4d,0x1b,0x5f,0xfd,0x91,0x7e,0xec,0x71,0x1e,0x55,0x2a,0xad,0xcb,0x6e,0xc0,
        0x8c,0x94,0x24,0xab,0xe1,0x90,0x83,0xd8,0xba,0x23,0xad,0xf2,0xe6,0x74,0x7c,0x79,
        0xb4,0x21,0x69,0x14,0xfe,0x32,0xad,0x28,0x66,0x4c,0xa6,0xa9,0xe0,0x27,0x7b,0x30,
        0x71,0x42,0x03,0x4e,0x36,0xd6,0xe3,0x21,0xa7,0x08,0xf7,0x24,0x1d,0x62,0xf4,0x4b,
        0x92,0x84,0x4b,0x50,0xa8,0x17,0x50,0x47,0xed,0x03,0x9b,0x79,0x5e,0xe2,0xae,0x6f,
        0x2a,0xb4,0xd9,0x4d,0xb8,0xd4,0x5b,0x62,0xea,0x2b,0xca,0xfc,0xa4,0xa3,0xb5,0x81,
        0x88,0xde,0x87,0xbb,0x04,0x29,0xae,0x74,0x8f,0xab,0xfd,0x43,0x2f,0xe2,0x4f,0xa5,
        0x3f,0x51,0x6e,0x4f,0x6f,0x72,0x33,0xc3,0x0c,0xf2,0xee,0x22,0x82,0x1d,0x07,0x41,
        0x1f,0x98,0xe6,0xfe,0x19,0x4e,0x11,0xd5,0xd3,0xac,0x94,0xae,0x5c,0x11,0xa6,0xf9,
        0x38,0x80,0x89,0xfd,0x64,0x99,0xb2,0x6d,0x94,0xc7,0x2a,0x3d,0xbf,0xba,0x34,0xb3,
        0xdd,0x18,0x30,0xc1,0xf0,0x6f,0xbf,0x92,0x41,0x6f,0x28,0x63,0xec,0x56,0xfb,0x94,
        0x9e,0xab,0xf4,0xff,0x9e,0x2f,0x21,0x88,0x0a,0x11,0x47,0xf5,0x64,0x61,0x83,0x01,
        0x4d,0xc7,0x2d,0xab,0x8f,0x75,0x01,0xd4,0x61,0x5a,0x81,0x09,0xe7,0x98,0x95,0x9e,
        0xf9,0x39,0x75,0xfc,0x25,0x1d,0xc8,0x3b,0xf7,0x37,0x0e,0xf4,0x77,0xfa,0x3b,0x50,
        0xf4,0x0d,0xa4,0x65,0x00,0x46,0x1f,0xc3,0xbc,0xd6,0x66,0x49,0x56,0xc1,0xbd,0x3e,
        0xcf,0x92,0xd5,0x9d,0x02,0x4c,0xef,0xaf,0xe2,0xa3,0x44,0xdf,0x03,0x6c,0xa5,0xcb,
        0x5c,0x53,0x5f,0x97,0x4b,0xcc,0x61,0x86,0xd9,0x4c,0xa1,0xcb,0x40,0xb8,0xbb,0x9c,
        0xaa,0x1e,0xdb,0x89,0x3c,0xa3,0xde,0x0c,0x53,0xbc,0xb4,0x61,0x0d,0xa1,0x09,0x97,
        0x0c,0xff,0x24,0xe8,0x76,0xed,0x0f,0x46,0x40,0x22,0xf8,0x36,0xad,0x65,0xd7,0xe1,
        0x11,0x44,0x51,0x68,0xdb,0x09,0xdc,0x79,0xd2,0xea,0x25,0x20,0x9f,0x80,0xaf,0xdf,
        0x8c,0x7b,0xbc,0x00,0x8b,0x93,0x70,0x2a,0x7a,0xc2,0x34,0x33,0xa5,0xb0,0x59,0x35,
        0x8d,0x6f,0xfd,0xe4,0xe8,0x68,0x33,0x1e,0xe8,0x95,0x5e,0xc4,0xc0,0xf1,0xde,0xc9,
        0x65,0x2d,0xef,0x88,0x91,0xa5,0xcd,0x5b,0x0e,0x92,0x1d,0x69,0x31,0x81,0x88,0xbf,
        0xa5,0x04,0xa9,0xa3,0x69,0xa7,0x29,0x24,0x1c,0x25,0x28,0xf6,0x79,0xdc,0xdf,0x7d,
        0x1e,0x7f,0x84,0x28,0x91,0x0b,0x6e,0x00,0x84,0xfc,0x7a,0x81,0x58,0xc0,0xad,0xa8,
        0xe1,0x6c,0x1b,0x4d,0x69,0xae,0x07,0xb3,0xf7,0x02,0x4b,0x5e,0xd1,0x29,0xfb,0x24,
        0x3f,0xd8,0x45,0x87,0x92,0xad,0x9b,0x42,0x65,0x66,0x15,0x22,0x23,0x55,0x10,0x17,
        0xc9,0x0f,0x1c,0x8b,0xed,0x65,0x15,0xf2,0x00,0x95,0x8f,0xa3,0xd0,0xc1,0x77,0xe6,
        0x50,0x9f,0xf8,0x4e,0x9c,0x73,0x9c,0x49,0x38,0x3a,0xb4,0xf5,0x98,0x28,0xf9,0x35,
        0xe6,0x55,0x73,0x05,0xff,0xb4,0x9a,0x0a,0xbf,0x44,0xbc,0x6d,0x7e,0x8a,0x9e,0xea,
        0xda,0x3e,0x66,0x24,0xb7,0x45,0xb8,0x3c,0x85,0xdf,0x20,0xa1,0xc2,0x22,0xb0,0x2a,
        0xbf,0xa7,0xea,0x62,0xa6,0x83,0xe0,0x23,0xbc,0x78,0x99,0x66,0xe4,0x6d,0xb7,0x59,
        0x65,0x1c,0x57,0xb2,0xec,0x0b,0x39,0x43,0xd5,0xbd,0x21,0xcf,0xa6,0x29,0x7c,0x1d,
        0xdc,0x6b,0x47,0x4a,0xeb,0xba,0x2d,0x63,0x80,0x9a,0xef,0x34,0x09,0x52,0x09,0x5a,
        0x77,0xa1,0x93,0xa0,0x42,0xad,0x65,0x88,0xae,0x3c,0x7e,0x27,0x4e,0x26,0xa7,0x36,
        0xc6,0x0b,0x53,0x67,0xd4,0x41,0xca,0xf5,0x92,0x10,0x86,0x7f,0xf5,0x22,0xdd,0x16,
        0x9a,0x35,0xe1,0x95,0xc2,0x13,0x85,0x30,0x9b,0xc4,0x01,0x50,0xc1,0x02,0x77,0x9f,
        0x04,0xed,0xd6,0x5e,0x6c,0x00,0xff,0xff,0x7a,0x44,0x26,0xf0,0xb1,0xc3,0x7b,0xb5,
        0x55,0x40,0x0a,0x39,0x73,0x25,0xe0,0x66,0x21,0xbd,0x70,0xf3,0x07,0xa3,0x35,0x7d,
        0x1e,0x7b,0x98,0xda,0xb8,0xdf,0x13,0xaa,0xc1,0x9c,0x97,0x2e,0x44,0x1f,0x2b,0x5e,
        0x30,0x2a,0xd7,0x35,0x5d,0xcc,0xc0,0x50,0xca,0x8f,0x94,0xb7,0x29,0xf3,0x28,0xfb,
        0x9d,0x1b,0x60,0x81,0xc2,0xc7,0x50,0x1d,0xee,0x82,0xa0,0xe2,0xb6,0x1d,0x35,0x39,
        0xb4,0x5b,0x0d,0x31,0x88,0xee,0x6b,0x16,0x1d,0xa2,0x35,0x45,0x2e,0xd9,0x9a,0x3e,
        0x08,0x37,0xf7,0xfb,0x91,0x9e,0xfc,0x81,0x89,0x5d,0x0b,0xb4,0x10,0xa4,0xe0,0x6f,
        0x68,0x3c,0x77,0xd4,0xfd,0x74,0x2a,0xe1,0xa2,0x5f,0x1b,0x44,0x1e,0x3c,0xd1,0x71,
        0xe7,0x36,0x26,0xf1,0x2d,0x4e,0x60,0xfd,0x1a,0x95,0x9e,0x4b,0x59,0x9e,0x76,0x28,
        0xd5,0x33,0xdc,0xc7,0xc3,0x47,0x45,0xd9,0xe2,0x2c,0x0d,0x5d,0x01,0x06,0x16,0xba,
        0xc3,0x80,0xb3,0x0b,0x9f,0xbd,0xc4,0xba,0x2a,0x92,0x22,0x50,0x99,0xf2,0x3d,0x8b,
        0x81,0xa9,0x03,0xb2,0xe2,0x4d,0x04,0x25,0x64,0x72,0xd4,0x38,0xe0,0x1e,0xb1,0x41,
        0x22,0x7d,0x66,0xf0,0xee,0xd5,0x6f,0xdf,0x40,0xbb,0x5e,0x6a,0xd8,0x88,0x7e,0xc1,
        0xf6,0x07,0xb5,0x3b,0x63,0x70,0xaf,0xee,0xb0,0x9a,0x38,0x7c,0xc2,0x6c,0xea,0x2f,
        0x8f,0x95,0x09,0x49,0x22,0x7c,0xab,0x95,0xe5,0x7a,0x1c,0x42,0x1f,0x48,0x80,0xf1,
        0xbc,0xb3,0xba,0x0d,0x4d,0x97,0x8d,0x5b,0x4f,0x0a,0x01,0xd2,0xb0,0xd8,0x09,0xac,
        0x8f,0x30,0x62,0xbd,0x44,0x9c,0xbe,0x04,0xa0,0x36,0x22,0x80,0x75,0x1a,0x8d,0x44,
        0x59,0x17,0xda,0xce,0xa8,0xaa,0xe7,0x95,0xc8,0x2c,0xf7,0xe1,0xb1,0x4a,0x55,0xdf,
        0xac,0xb6,0x3b,0xf5,0x5a,0x1c,0xf1,0x53,0xf9,0x58,0x39,0xcb,0xe3,0xe6,0xeb,0xe2,
        0x57,0x99,0xdd,0x27,0x7c,0x90,0x05,0xc3,0xa3,0x67,0xe2,0x52,0xcd,0xaa,0x17,0xf1,
        0x6d,0x8f,0x5a,0x98,0x6f,0xe4,0x8c,0xab,0x78,0x46,0x29,0xcb,0x70,0x94,0xe3,0xf2,
        0x3e,0xa3,0x8a,0xbf,0xd2,0x33,0x2f,0x0e,0x69,0x22,0x89,0xcc,0x0c,0xe0,0x98,0x0a,
        0x5a,0x23,0x87,0x4f,0x88,0xdc,0xd7,0x33,0xa6,0x69,0xba,0x29,0x24,0x0c,0xbd,0x9d,
        0x94,0x9c,0xaa,0x3f,0xb1,0x7a,0xad,0x9e,0xa1,0xc7,0xb5,0xf8,0x77,0xd4,0x1d,0x50,
        0xfc,0xda,0x8c,0xc2,0xaf,0xec,0x1a,0x14,0x0a,0x29,0xb4,0x8d,0x07,0x36,0xc1,0x0a,
        0xe3,0xec,0x05,0x4e,0x22,0x4d,0xc6,0x9a,0xd3,0xbd,0x2e,0x7d,0x15,0x6f,0xf1,0xee,
        0xda,0x1d,0x30,0x98,0xeb,0xfc,0x9c,0x75,0x2d,0xef,0xde,0x9e,0x22,0xfa,0x37,0x62,
        0xb2,0xfa,0x63,0x95,0x2c,0x94,0xc4,0x2a,0x88,0x6c,0xbc,0x05,0xef,0x97,0x5b,0x0a,
        0x7d,0x52,0x3a,0x7a,0x45,0xf4,0xa6,0x7f,0x95,0x21,0x01,0x05,0x7c,0x41,0x66,0xcc,
        0x8a,0x30,0x8c,0xbb,0xd7,0x37,0xed,0x78,0x46,0x3c,0x27,0x35,0x0b,0x35,0xa2,0xcd,
        0x6b,0xe3,0x73,0x0f,0xc3,0xbc,0x80,0x59,0xcc,0x29,0xe5,0x6a,0x1d,0xf1,0x97,0x71,
        0xf2,0xf5,0x47,0x69,0x2b,0x1f,0x8a,0xa9,0x98,0x95,0x36,0xb7,0x73,0x32,0x0f,0x5e,
        0x2e,0x36,0xa3,0x00,0x70,0x3c,0x72,0x2d,0x5a,0x6d,0x52,0x73,0x0e,0xf4,0x12,0x78,
        0x72,0xb1,0x5e,0x47,0x31,0x32,0xe2,0xe8,0x03,0xdf,0xb3,0x33,0x2f,0x74,0xea,0xe5},
        /*TST_input_dataSize*/
        1536*sizeof(DxUint8_t),
        /*TST_HmacResultBuff*/
        {0},
        /*TST_SHA1_Expected_output_data*/
        {0xfa,0x57,0x3b,0x54,0xc6,0x03,0xcd,0xc7,0x01,0x36,0xd8,0x08,0x5c,0x65,0xb9,0x70,
        0xbb,0x41,0x8f,0x36}, 
        /*TST_SHA1_Expected_output_dataSize*/
        CRYS_HASH_SHA1_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),  
        /*TST_MD5_Expected_output_data*/
        {0xba,0x59,0xe1,0xbf,0x85,0x7f,0xb6,0xe1,0xf8,0x8b,0x80,0x55,0xb9,0xad,0x0f,0x68}, 
        /*TST_MD5_Expeced_dataSize*/
        CRYS_HASH_MD5_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),  
        /*TST_SHA224_Expected_output_data*/
        {0xc5,0x7f,0x71,0x2b,0x64,0x40,0xd0,0xc8,0xc8,0x46,0xb3,0xfe,0xed,0x96,0x5a,0x60,
        0x20,0x00,0xb7,0x1c,0x4f,0x65,0x8e,0xdb,0x2c,0xc6,0x80,0x9d}, 
        /*TST_SAH224_expected_dataSize*/
        CRYS_HASH_SHA224_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),      
        /*TST_SHA256_Expected_output_data*/
        {0x8b,0x61,0xf7,0xf5,0x5e,0xba,0x18,0xb3,0x26,0x38,0x56,0xc5,0x5f,0x78,0x7a,0xbc,
        0x47,0xd3,0xd2,0x34,0xb0,0x21,0x88,0x06,0xae,0x37,0x45,0xa2,0x3c,0x94,0xdf,0x51}, 
        /*TST_SAH256_expected_dataSize*/
        CRYS_HASH_SHA256_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),      
        /*TST_SHA384_Expected_output_data*/
        {0x1f,0xbe,0x97,0xc6,0xbc,0x19,0x06,0xf8,0xd8,0x1c,0xbe,0xfc,0x84,0x61,0x29,0xba,
        0x9d,0xad,0x4f,0x2a,0x5f,0x1d,0xe8,0x65,0x64,0x6d,0x97,0xcf,0x6f,0x97,0x63,0x8d,
        0x0d,0x8c,0x2f,0xf2,0x66,0xe9,0xbe,0xc6,0xa4,0xc0,0x41,0x08,0xb5,0x33,0x79,0xf0}, 
        /*TST_SAH384_expected_dataSize*/
        CRYS_HASH_SHA384_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),      
        /*TST_SHA512_Expected_output_data*/
        {0x95,0x1c,0x78,0x19,0xb4,0xb4,0xaf,0xb0,0xe1,0x90,0x9b,0xa4,0x9c,0x67,0xb9,0x27,
        0x52,0x94,0xe8,0x48,0xab,0xb5,0x17,0xc3,0x11,0xad,0xf1,0x25,0x88,0x03,0xe2,0xd1,
        0xb6,0x12,0x80,0x19,0x2c,0xc0,0xc3,0xb4,0xce,0x72,0x68,0x29,0x25,0xf0,0x6d,0x50,
        0x84,0x80,0xe4,0xc1,0xa0,0x6c,0xb3,0x10,0x86,0x3d,0x8d,0x95,0xa4,0x48,0x9d,0xd9}, 
        /*TST_SAH512_expected_dataSize*/
        CRYS_HASH_SHA512_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t), 
        CRYS_HASH_SHA1_mode           
    }
};





